use master
GO

set nocount on 

declare @ProjectPayload01 nvarchar(max) = N'
-- 2419 DEV-91477
IF NOT EXISTS (SELECT 1 FROM sys.types WHERE is_table_type = 1 AND name = ''ResponseList'')
BEGIN
	CREATE TYPE [dbo].[ResponseList]
	AS TABLE
	(
		[RpsRespondent] VARCHAR(10) NOT NULL,
		[RpsQuestion] NVARCHAR(32) NOT NULL,
		[RpsMatrix] BIGINT NOT NULL,
		[RpsMention] INT NOT NULL,
		[RpsType] INT NOT NULL,
		[RpsContent] NVARCHAR(100) NULL,
		[RpsOpened] NVARCHAR(MAX) NULL,
		[CallId] INT NULL
	);
END
'

declare @ProjectPayload02 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[sp_UpdateOrCreateResponses]'') AND type in (N''P'', N''PC''))
	DROP PROCEDURE [dbo].[sp_UpdateOrCreateResponses]
'

declare @ProjectPayload03 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[sp_UpdateOrCreateResponses]
	@Responses AS [dbo].[ResponseList] READONLY,
	@ProjectId INT, 
	@CollectMode INT,
    @ModifiedBy INT,
	@Modified DATETIME,
	@Source NVARCHAR(MAX)
AS
BEGIN
	SET NOCOUNT ON;

	IF @Modified IS NULL
	BEGIN
		SET @Modified = GETUTCDATE();
	END

	UPDATE r
	SET r.[RpsContent] = l.[RpsContent],
		r.[RpsOpened] = l.[RpsOpened],
		r.[CallId] = l.[CallId],
		r.[ProjectId] = @ProjectId,
		r.[CollectMode] = CASE WHEN @CollectMode < 0 THEN r.[CollectMode] ELSE @CollectMode END,
		r.[ModifiedBy] = @ModifiedBy,
		r.[Modified] = @Modified,
		r.[Source] = @Source
	FROM @Responses l
	INNER JOIN [dbo].[Response] r
		ON l.[RpsRespondent] = r.[RpsRespondent]
		AND l.[RpsQuestion] = r.[RpsQuestion]
		AND l.[RpsMatrix] = r.[RpsMatrix]
		AND l.[RpsMention] = r.[RpsMention]
		AND l.[RpsType] = r.[RpsType];

	INSERT INTO [dbo].[Response] (
		[RpsRespondent],
		[RpsQuestion],
		[RpsMatrix],
		[RpsMention],
		[RpsType],
		[RpsContent],
		[RpsOpened],
		[CallId],
		[ProjectId],
		[CollectMode],
		[ModifiedBy],
		[Modified],
		[Source])
	SELECT
		l.[RpsRespondent],
		l.[RpsQuestion],
		l.[RpsMatrix],
		l.[RpsMention],
		l.[RpsType],
		l.[RpsContent],
		l.[RpsOpened],
		l.[CallId],
		@ProjectId,
		@CollectMode,
		@ModifiedBy,
		@Modified,
		@Source
	FROM @Responses l
	LEFT JOIN [dbo].[Response] r
		ON l.[RpsRespondent] = r.[RpsRespondent]
		AND l.[RpsQuestion] = r.[RpsQuestion]
		AND l.[RpsMatrix] = r.[RpsMatrix]
		AND l.[RpsMention] = r.[RpsMention]
		AND l.[RpsType] = r.[RpsType]
	WHERE r.[RpsRespondent] IS NULL;
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @TotalProjectsDB int,
        @ThisProjectsDB nvarchar(128),
		@ProjectsDBCounter int = 0, 
		@ProjectsDBCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

		
insert into #DB 
SELECT [name] AS DBName, 0 AS Processed FROM sys.databases WHERE [name] like 'VOXCO_Project_%';
	     
select @TotalProjectsDB = count(*) 
	    from #DB
	
set @ProjectsDBCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
open @ProjectsDBCursor
fetch next from @ProjectsDBCursor into @ThisProjectsDB
while @@FETCH_STATUS = 0 begin
	select @ProjectsDBCounter += 1
	select @DBSQL = @ThisProjectsDB + N'.sys.sp_executesql'
	select @StatusMessage = 'Updating Project database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ProjectsDBCounter / @TotalProjectsDB
	raiserror (@StatusMessage, 0, 1, @ThisProjectsDB, @ProjectsDBCounter, @TotalProjectsDB, @StatusPercent) with nowait
	
	SELECT 'Updating Project DB: ' + @ThisProjectsDB
        print 'Project Payload 1'
        if isnull(@ProjectPayload01, '') <> '' exec @DBSQL @ProjectPayload01

        print 'Project Payload 2'
        if isnull(@ProjectPayload02, '') <> '' exec @DBSQL @ProjectPayload02

        print 'Project Payload 3'
        if isnull(@ProjectPayload03, '') <> '' exec @DBSQL @ProjectPayload03

	print 'All Project Payload done!'

	update #DB set Processed = 1 where current of @ProjectsDBCursor
	fetch next from @ProjectsDBCursor into @ThisProjectsDB
end

close @ProjectsDBCursor
deallocate @ProjectsDBCursor

--select * from #DB

drop table #DB

